/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.blocks.interfaces;

import com.ldtteam.structurize.api.util.BlockPosUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Tuple;

public interface IBlueprintDataProvider {
    public static final String TAG_SCHEMATIC_NAME = "schematicName";
    public static final String TAG_CORNER_ONE = "corner1";
    public static final String TAG_CORNER_TWO = "corner2";
    public static final String TAG_TAG_POS = "tagPos";
    public static final String TAG_TAG_NAME = "tagName";
    public static final String TAG_TAG_NAME_LIST = "tagNameList";
    public static final String TAG_POS_TAG_MAP = "posTagMap";
    public static final String TAG_BLUEPRINTDATA = "blueprintDataProvider";

    public String getSchematicName();

    public void setSchematicName(String var1);

    public Map<BlockPos, List<String>> getPositionedTags();

    public void setPositionedTags(Map<BlockPos, List<String>> var1);

    public Tuple<BlockPos, BlockPos> getSchematicCorners();

    default public Tuple<BlockPos, BlockPos> getInWorldCorners() {
        Tuple<BlockPos, BlockPos> schematicCorners = this.getSchematicCorners();
        return new Tuple((Object)this.getTilePos().m_141952_((Vec3i)schematicCorners.m_14418_()), (Object)this.getTilePos().m_141952_((Vec3i)this.getSchematicCorners().m_14419_()));
    }

    public void setSchematicCorners(BlockPos var1, BlockPos var2);

    default public void writeSchematicDataToNBT(CompoundTag originalCompound) {
        CompoundTag compoundNBT = new CompoundTag();
        compoundNBT.m_128359_(TAG_SCHEMATIC_NAME, this.getSchematicName());
        BlockPosUtil.writeToNBT(compoundNBT, TAG_CORNER_ONE, (BlockPos)this.getSchematicCorners().m_14418_());
        BlockPosUtil.writeToNBT(compoundNBT, TAG_CORNER_TWO, (BlockPos)this.getSchematicCorners().m_14419_());
        IBlueprintDataProvider.writeMapToCompound(compoundNBT, this.getPositionedTags());
        originalCompound.m_128365_(TAG_BLUEPRINTDATA, (Tag)compoundNBT);
    }

    public static void writeMapToCompound(CompoundTag compoundNBT, Map<BlockPos, List<String>> tagPosMap) {
        ListTag tagPosList = new ListTag();
        for (Map.Entry<BlockPos, List<String>> entry : tagPosMap.entrySet()) {
            CompoundTag posTagCompound = new CompoundTag();
            BlockPosUtil.writeToNBT(posTagCompound, TAG_TAG_POS, entry.getKey());
            ListTag tagList = new ListTag();
            for (String tag : entry.getValue()) {
                CompoundTag tagCompound = new CompoundTag();
                tagCompound.m_128359_(TAG_TAG_NAME, tag);
                tagList.add((Object)tagCompound);
            }
            posTagCompound.m_128365_(TAG_TAG_NAME_LIST, (Tag)tagList);
            tagPosList.add((Object)posTagCompound);
        }
        compoundNBT.m_128365_(TAG_POS_TAG_MAP, (Tag)tagPosList);
    }

    default public void readSchematicDataFromNBT(CompoundTag originalCompound) {
        if (!originalCompound.m_128441_(TAG_BLUEPRINTDATA)) {
            return;
        }
        CompoundTag compoundNBT = originalCompound.m_128469_(TAG_BLUEPRINTDATA);
        this.setSchematicName(compoundNBT.m_128461_(TAG_SCHEMATIC_NAME));
        BlockPos corner1 = BlockPosUtil.readFromNBT(compoundNBT, TAG_CORNER_ONE);
        BlockPos corner2 = BlockPosUtil.readFromNBT(compoundNBT, TAG_CORNER_TWO);
        this.setSchematicCorners(corner1, corner2);
        this.setPositionedTags(IBlueprintDataProvider.readTagPosMapFrom(compoundNBT));
    }

    public static Map<BlockPos, List<String>> readTagPosMapFrom(CompoundTag compoundNBT) {
        HashMap<BlockPos, List<String>> tagPosMap = new HashMap<BlockPos, List<String>>();
        if (!compoundNBT.m_128441_(TAG_POS_TAG_MAP)) {
            return tagPosMap;
        }
        ListTag tagPosMapNBT = compoundNBT.m_128437_(TAG_POS_TAG_MAP, 10);
        for (Tag tagPosMapEntry : tagPosMapNBT) {
            if (!(tagPosMapEntry instanceof CompoundTag)) continue;
            CompoundTag entry = (CompoundTag)tagPosMapEntry;
            BlockPos tagPos = BlockPosUtil.readFromNBT(entry, TAG_TAG_POS);
            HashSet<String> tagList = new HashSet<String>();
            ListTag tagListNbt = entry.m_128437_(TAG_TAG_NAME_LIST, 10);
            for (Tag tagEntryNBT : tagListNbt) {
                if (!(tagEntryNBT instanceof CompoundTag)) continue;
                CompoundTag tagEntry = (CompoundTag)tagEntryNBT;
                tagList.add(tagEntry.m_128461_(TAG_TAG_NAME));
            }
            tagPosMap.put(tagPos, new ArrayList(tagList));
        }
        return tagPosMap;
    }

    default public void removeTag(BlockPos pos, String tag) {
        Map<BlockPos, List<String>> data = this.getPositionedTags();
        if (data.containsKey(pos)) {
            data.get(pos).remove(tag);
            if (data.get(pos).isEmpty()) {
                data.remove(pos);
            }
        }
        this.setPositionedTags(data);
    }

    default public void addTag(BlockPos pos, String tag) {
        Map<BlockPos, List<String>> data = this.getPositionedTags();
        if (data.containsKey(pos)) {
            data.get(pos).add(tag);
        } else {
            ArrayList<String> list = new ArrayList<String>();
            list.add(tag);
            data.put(pos, list);
        }
        this.setPositionedTags(data);
    }

    default public Map<BlockPos, List<String>> getWorldTagPosMap() {
        HashMap<BlockPos, List<String>> tagPosMap = new HashMap<BlockPos, List<String>>();
        for (Map.Entry<BlockPos, List<String>> entry : this.getPositionedTags().entrySet()) {
            tagPosMap.put(entry.getKey().m_141952_((Vec3i)this.getTilePos()), entry.getValue());
        }
        return tagPosMap;
    }

    default public Map<String, Set<BlockPos>> getWorldTagNamePosMap() {
        HashMap<String, Set<BlockPos>> tagNamePosMap = new HashMap<String, Set<BlockPos>>();
        for (Map.Entry<BlockPos, List<String>> entry : this.getPositionedTags().entrySet()) {
            for (String tagName : entry.getValue()) {
                tagNamePosMap.computeIfAbsent(tagName, new Function<String, Set<BlockPos>>(){

                    @Override
                    public Set<BlockPos> apply(String s) {
                        return new HashSet<BlockPos>();
                    }
                }).add(entry.getKey().m_141952_((Vec3i)this.getTilePos()));
            }
        }
        return tagNamePosMap;
    }

    default public BlockPos getRealWorldPos(BlockPos relativePos) {
        return relativePos.m_141952_((Vec3i)this.getTilePos());
    }

    public BlockPos getTilePos();

    public ClientboundBlockEntityDataPacket getUpdatePacket();
}

